/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

class PutHeader {
    String PATH = "/home/pineau/Eclipse/Healpix/src";
    String[] EXCEPTION = new String[]{"savot", "astrores", "table"};
    String HEAD = "// Copyright 2017-2018 - Universite de Strasbourg/CNRS\n// The CDS HEALPix library is developped by the Centre de Donnees\n// astronomiques de Strasbourgs (CDS) from the following external papers:\n//  - [Gorsky2005]     - \"HEALPix: A Framework for High-Resolution Discretization and\n//                       Fast Analysis of Data Distributed on the Sphere\"\n//                       http://adsabs.harvard.edu/abs/2005ApJ...622..759G\n//  - [Calabretta2004] - \"Mapping on the HEALPix grid\"\n//                       http://adsabs.harvard.edu/abs/2004astro.ph.12607C\n//  - [Calabretta2007] - \"Mapping on the HEALPix grid\"\n//                       http://adsabs.harvard.edu/abs/2007MNRAS.381..865C\n//  - [Reinecke2015]   - \"Efficient data structures for masks on 2D grids\"\n//                       http://adsabs.harvard.edu/abs/2015A&A...580A.132R\n// It is distributed under the terms of the BSD License 2.0\n//\n// This file is part of the CDS HEALPix library.\n//\n";

    PutHeader() {
        int n = this.putHead(new File(this.PATH), 0);
        System.out.println("Ent\u00c3\u00aate maj dans " + n + " fichier" + (n > 1 ? "s" : ""));
    }

    int putHead(File dir, int depth) {
        File[] files;
        int n = 0;
        for (File f : files = dir.listFiles()) {
            try {
                String name = f.getCanonicalPath();
                if (f.isDirectory()) {
                    if (depth == 0) {
                        int off = name.lastIndexOf(47);
                        if (off == -1) {
                            off = name.lastIndexOf(92);
                        }
                        String d = name.substring(off + 1);
                        boolean trouve = false;
                        for (String ex : this.EXCEPTION) {
                            if (!d.equals(ex)) continue;
                            trouve = true;
                            break;
                        }
                        if (trouve) continue;
                    }
                    n += this.putHead(f, depth + 1);
                }
                if (!f.getCanonicalPath().endsWith(".java")) continue;
                this.insertHead(f);
                ++n;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insertHead(File f) throws Exception {
        String tmp = f.getCanonicalPath() + ".tmp";
        File g = new File(tmp);
        BufferedWriter t = null;
        BufferedReader s = null;
        try {
            s = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            if (g.exists()) {
                g.delete();
            }
            t = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(g)));
            this.writeHead(t);
            this.skipPreviousHead(s);
            this.writeContent(s, t);
            t.close();
            s.close();
            f.delete();
            g.renameTo(f);
        }
        catch (Exception e) {
            System.out.println("Probl\u00c3\u00a8me sur " + f.getCanonicalPath() + " [" + e.getMessage() + "] -> ignor\u00c3\u00a9");
        }
        finally {
            if (t != null) {
                t.close();
            }
            if (s != null) {
                s.close();
            }
        }
    }

    void writeContent(BufferedReader s, BufferedWriter t) throws Exception {
        String s1;
        while ((s1 = s.readLine()) != null) {
            t.write(s1);
            t.newLine();
        }
    }

    void skipPreviousHead(BufferedReader s) throws Exception {
        while (true) {
            s.mark(2048);
            String s1 = s.readLine();
            if (s1 == null) break;
            if (s1.trim().length() > 0 && !s1.startsWith("//")) {
                s.reset();
                return;
            }
            String string = s1.trim();
        }
    }

    void writeHead(BufferedWriter t) throws Exception {
        StringTokenizer st = new StringTokenizer(this.HEAD, "\n");
        while (st.hasMoreTokens()) {
            t.write(st.nextToken());
            t.newLine();
        }
        t.newLine();
    }

    public static void main(String[] args) {
        try {
            new PutHeader();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

